
class Table
  def initialize(x, y = 1, z = 1)
    y = [y.abs,1].max # Just in case the user types 0, or a negative value
    z = [z.abs,1].max
    @dim = 1 + (y <=> 1) + (z <=> 1)    # <=> returns 1 if greater, 0 if the same, -1 if smaller
    @xsize, @ysize, @zsize = x, y, z # We don't need to set the 1 to 1 ;)
    @data = Array.new(@xsize * @ysize * @zsize, 0)
  end
  def [](x, y = 0, z = 0)
    @data[x + y * @xsize + z * @xsize * @ysize]
  end
  def []=(*args)
    x = args[0]
    y = args.size > 2 ? args[1] : 0
    z = args.size > 3 ? args[2] : 0
    v = args.pop
    @data[x + y * @xsize + z * @xsize * @ysize] = v
  end
  def _dump(d = 0)
    [@dim, @xsize, @ysize, @zsize, @xsize * @ysize * @zsize].pack('LLLLL') << @data.pack("S#{@xsize * @ysize * @zsize}")
  end
  def self._load(s)
    size, nx, ny, nz, items = *s[0, 20].unpack('LLLLL')
    t = Table.new(nx, ny, nz)
    t.data = s[20, items * 2].unpack("S#{items}")
    t
  end
  attr_accessor(:xsize, :ysize, :zsize, :data)

  def comparer(table)
    # acomp
    #return false if table.is_a?(self.class) == false
    return false if @xsize != table.xsize
    return false if @ysize != table.ysize
    return false if @zsize != table.zsize
    return false if @data != table.data
    return true
  end

end




#module TABLE

=begin
Auteur : vgvgf  
source : http://www.rmxp.org/forums/index.php?topic=49838.msg472866
=end

=begin
class Table
  def initialize(x,y=1,z=1)
    @xsize,@ysize,@zsize=x,y,z
    @data=Array.new(x*y*z, 0)
  end
  def [](x,y=0,z=0)
    @data[x+y*@xsize+z*@xsize*@ysize]
  end
  def []=(*args)
    x=args[0]
    y=args.size>2 ?args[1]:0
    z=args.size>3 ?args[2]:0
    v=args.pop
    @data[x+y*@xsize+z*@xsize*@ysize]=v
  end
  def _dump(d=0)
    s=[3].pack('L')
    s+=[@xsize].pack('L')+[@ysize].pack('L')+[@zsize].pack('L')
    s+=[@xsize*@ysize*@zsize].pack('L')
    for z in 0...@zsize
      for y in 0...@ysize
        for x in 0...@xsize
          s+=[@data[x+y*@xsize+z*@xsize*@ysize],0,0].pack('L')[0,2]
        end
      end
    end
    s
  end
  attr_reader(:xsize,:ysize,:zsize,:data)
  class << self
    def _load(s)
      size=s[0,4].unpack('L')[0]
      nx=s[4,4].unpack('L')[0]
      ny=s[8,4].unpack('L')[0]
      nz=s[12,4].unpack('L')[0]
      data=[]
      pointer=20
      loop do
        data.push((s[pointer,2]+"\000\000").unpack('L')[0])
        pointer+=2
        break if pointer > s.size-1
      end
      t=Table.new(nx,ny,nz)
      n=0
      for z in 0...nz
        for y in 0...ny
          for x in 0...nx
            t[x,y,z]=data[n]
            n+=1
          end
        end
      end
      t
    end
  end
end




class Table

  def ==(table)
    return false if @xsize != table.xsize
    return false if @ysize != table.ysize
    return false if @zsize != table.zsize

    return false if @data != table.data

    return true

  end
end



=end

=begin

class BigTable
  def initialize(x, y = 1, z = 1)
    x = [x, 256 ** 4].min
    y = [y, 256 ** 4].min
    z = [z, 256 ** 4].min
    @xsize, @ysize, @zsize = x, y, z
    @data = Array.new(x * y * z, 0)
  end
  def [](x, y = 0, z = 0)
    x = [x, @xsize].min
    y = [y, @ysize].min
    z = [z, @zsize].min
    @data[x + y * @xsize + z * @xsize * @ysize]
  end
  def []=(*args)
    x = [args[0], @xsize].min
    y = [args.size>2 ?args[1] : 0, @ysize].min
    z = [args.size>3 ?args[2] : 0, @zsize].min
    v = [args.pop, 256 ** 4].min
    @data[x + y * @xsize + z * @xsize * @ysize] = v
  end
  def _dump(d = 0)
    s = [3].pack('L')
    s += [@xsize].pack('L') + [@ysize].pack('L') + [@zsize].pack('L')
    s += [@xsize * @ysize * @zsize].pack('L')
    for z in 0...@zsize
      for y in 0...@ysize
        for x in 0...@xsize
          s += [@data[x + y * @xsize + z * @xsize * @ysize]].pack('L')
        end
      end
    end
    s
  end
  attr_reader(:xsize, :ysize, :zsize, :data)
  class << self
    def _load(s)
      nx = s[0, 4].unpack('L')[0]
      ny = s[4, 4].unpack('L')[0]
      nz = s[8, 4].unpack('L')[0]
      size = s[12, 4].unpack('L')[0]
      data = []
      pointer = 16
      loop do
        data.push(s[pointer, 4].unpack('L')[0])
        pointer += 4
        break if pointer > s.size - 1
      end
      t = BigTable.new(nx, ny, nz)
      n = 0
      for z in 0...nz
        for y in 0...ny
          for x in 0...nx
            t[x, y, z] = data[n]
            n += 1
          end
        end
      end
      t
    end
  end
end


class Table

    attr_reader   :data
    attr_reader   :xsize
    attr_reader   :ysize
    attr_reader   :zsize


  def initialize(xsize, ysize=0, zsize=0)

    #puts "#{xsize}, #{ysize}, #{zsize}"
  
    ysize = 0 if (ysize < 0)
    zsize = 0 if (zsize < 0)

    @xsize = xsize
    @ysize = ysize
    @zsize = zsize
    
    
    #@data = Array.new(xsize)
    
    @data = Array.new(xsize)
    
    for i in 0...xsize
        @data[i] = Array.new(ysize)
    end


    if zsize > 0
        for i in 0...xsize
            for j in 0...ysize
                #p i, j
                @data[i][j] = Array.new(zsize)
            end    
        end
    end

  end


  def resize(xsize, ysize=@ysize, zsize=@zsize) 

  end


def [](x, y=-1, z=-1)
    if y < @ysize
        return @data[x]
    end
    if z < @zsize
        return @data[x][y]
    end
    
    return @data[x][y][z]
    
end



def []=(x, y=0, z=0, value=nil)
  #print x,y,z, " = ",value
  @data[x][y][z] = value
end


def Table._load(param)

  array = param.unpack('s*')
  $a = array
  #p array 
  #gets
  #return "Table Gh'ack "  
  xsize = array[2]
  ysize = array[4]
  zsize = array[6]
  nb_elem = array[8]
  #p xsize, ysize, zsize,
  #p array


  t = Table.new(xsize, ysize, zsize)
  x = y = z = 0


  for i in 10...nb_elem+10
    t[x,y,z] = array[i]
    x += 1
    if x == xsize
      x = 0
      y += 1
      if y == ysize
        y = 0
        z += 1
        if z == zsize
        end
      end
    end
  end

  
  p t
  gets
  $t = t
  return t

end


def Table._dump(param)
  p "a"*300
  gets
  array = []
  array[0] = @zsize
  array[1] = 0
  array[2] = @xsize
  array[3] = 0
  array[4] = @ysize
  array[5] = 0
  array[6] = @zsize
  array[7] = 0
  array[8] = @xsize*@ysize*@zsize
  array[9] = 0

  x = y = z = 0
  for i in 10...array[8]+10
    array[i] = @data[z][y][x]
    x += 1
    if x == xsize
      x = 0
      y += 1
      if y == ysize
        y = 0
        z += 1
        if z == zsize
        end
      end
    end
  end
  
  p array, array.size
  gets
  
  # On compresse le tableau
  return array.pack('s*')
  
end

end
=end